/***************************************************************************
*
* Copyright 2010,2011 BMW Car IT GmbH
*
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*        http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*
****************************************************************************/
#include "SurfaceGetIpAcceptanceCommand.h"
#include "ICommandExecutor.h"
#include "Scene.h"
#include "Log.h"

ExecutionResult SurfaceGetIpAcceptanceCommand::execute(ICommandExecutor* executor)
{
    Scene& scene = *(executor->getScene());

    ExecutionResult result = ExecutionFailed;

    Surface* surface = scene.getSurface(m_idtoSet);

    if (surface)
    {
        if (surface->getAcceptedSeats(m_pSeatArray, m_psizeSeatArray))
        {
            result = ExecutionSuccess;
            LOG_DEBUG("SurfaceGetIpAcceptanceCommand",
                      "Got input acceptance for" << *m_psizeSeatArray << " seats");
        }
    }

    return result;
}

const std::string SurfaceGetIpAcceptanceCommand::getString()
{
    std::stringstream description;
    description << "SurfaceGetIpAcceptanceCommand("
                << "idtoSet=" << m_idtoSet << "(0x" << std::hex << m_idtoSet << ")" << std::dec
                << ")";
    return description.str();
}
